{{ *****************************************************
   *  Example3.1    : For "ET-BASE PX32 V1.0           *
   *                                                   *
   *  File Name   : Ex3.1_Key_On_TV.spin               *
   *  Compiler    : Propeller V1.06                    *
   *  Create By   : Sittiphol Yooyod (www.ett.co.th)   *
   *  Last Update : 28/January/2007                    *
   *  Function    : To Press Key Board Display         *
   *                charecter GPH of key On TV         *                  
   *                                                   *
   ***************************************************** }}


CON

  _clkmode = xtal1 + pll16x
  _xinfreq = 5_000_000
  _stack = ($3000 + $3000 + 100) >> 2   'accomodate display memory and stack

  x_tiles = 16
  y_tiles = 12

  paramcount = 14       
  bitmap_base = $2000
  display_base = $5000

  lines = 5
  thickness = 2

 

VAR


  long  tv_status     '0/1/2 = off/visible/invisible           read-only
  long  tv_enable     '0/? = off/on                            write-only
  long  tv_pins       '%ppmmm = pins                           write-only
  long  tv_mode       '%ccinp = chroma,interlace,ntsc/pal,swap write-only
  long  tv_screen     'pointer to screen (words)               write-only
  long  tv_colors     'pointer to colors (longs)               write-only               
  long  tv_hc         'horizontal cells                        write-only
  long  tv_vc         'vertical cells                          write-only
  long  tv_hx         'horizontal cell expansion               write-only
  long  tv_vx         'vertical cell expansion                 write-only
  long  tv_ho         'horizontal offset                       write-only
  long  tv_vo         'vertical offset                         write-only
  long  tv_broadcast  'broadcast frequency (Hz)                write-only
  long  tv_auralcog   'aural fm cog                            write-only

  word  screen[x_tiles * y_tiles]
  long  colors[64]

 

OBJ

  tv    : "tv"
  gr    : "graphics"
  kb    : "keyboard" 

PUB main | i,ch,x0,y0,fag,x,y

    x0 := 10
    y0 :=  50
  '-------------------- start tv -------------
  
  longmove(@tv_status, @tvparams, paramcount)
  tv_screen := @screen
  tv_colors := @colors
  tv.start(@tv_status)
 
  '-------------- init colors ------------
 
    colors[0] := $07089802    ''keep Color:$07=white,$08=Green,$98=Blue,Back Ground $02= Black  
  
  '----------- initial tile screen ----------
  
  repeat x from 0 to tv_hc - 1
    repeat y from 0 to tv_vc - 1
        i:= 0
      screen[x + y * tv_hc] := i << 10 + display_base >> 6 + x * tv_vc + y



  '----------- start and setup graphics ------------
  gr.start
  gr.setup(16, 12, 128, 96, bitmap_base)

    

  '------ Start keyboard ---------
  
   kb.start(26, 27)

repeat
    fag := 0
    gr.clear                   ''Clear Screen
    gr.textmode(2,2,6,5)       ''Set Text Size 
    gr.colorwidth(1,1)         ''Set Pixel Color Blue and Width=1
    gr.text(0,85,@str0)
  
    gr.textmode(2,2,6,5)       ''Set Text Size 
    gr.colorwidth(2,1)         ''Set Pixel Color Green and Width=1
    gr.text(-60,50,@str1)      

    gr.copy(display_base)   


  '----- Receive key ------
   
  repeat until fag ==1
  
      ch := kb.getkey              ''Read key
      
      if ch > $1F and ch < $7B     ''Check key Code --> Space to z
        gr.textmode(2,2,7,5)       ''Set Text Size 
        gr.colorwidth(3,1)         ''Set Pixel Color white and Width=1
        gr.text(x0,y0,@ch)
        x0 := x0+13                ''Space Text

        if x0 > 120                ''Check End Row
          x0 := -115
          y0 := y0-30

        if y0 < -70                ''Check End Page
           x0 := 10
           y0 := 50
           fag := 1
           
       '------- copy bitmap to TV --------
       
        gr.copy(display_base)

        
      if ch == $0D                  ''Check Enter Linf Feed
         x0  := -115
         y0 := y0-30
         if y0 < -70
            x0 := 10
            y0 := 50
            fag := 1
            
 
      

  
    

DAT

tvparams                long    0               'status
                        long    1               'enable
                        long    %001_0101       'pins
                        long    %0000           'mode
                        long    0               'screen
                        long    0               'colors
                        long    x_tiles         'hc
                        long    y_tiles         'vc
                        long    10              'hx
                        long    1               'vx
                        long    0               'ho
                        long    0               'vo
                        long    0               'broadcast
                        long    0               'auralcog

 

str0                    byte "..ETT DEMO KeyBoard..",0
str1                    byte "Enter key:",0